//
//  DisclosureButtonController.m
//  Nav
//
//  Created by Robert Górczyński on 11-07-05.
//

#import "DisclosureButtonController.h"
#import "NavAppDelegate.h" 
#import "DisclosureDetailController.h" 


@implementation DisclosureButtonController
@synthesize list; 

- (void)viewDidLoad { 
    NSArray *array = [[NSArray alloc] initWithObjects:@"Toy Story", 
                      @"Dawno temu w trawie", @"Toy Story 2", @"Potwory i spółka", 
                      @"Gdzie jest Nemo?", @"Iniemamocni", @"Auta", 
                      @"Ratatuj", @"WALL-E", @"Odlot", @"Toy Story 3",
                      @"Auta 2", @"Brave", nil]; 
    self.list = array; 
    [array release]; 
    [super viewDidLoad]; 
} 

- (void)viewDidUnload { 
	self.list = nil; 
	[childController release], childController = nil; 
} 

- (void)dealloc { 
	[list release]; 
	[childController release]; 
	[super dealloc]; 
} 

#pragma mark - 
#pragma mark Metody źródła danych tabeli 
- (NSInteger)tableView:(UITableView *)tableView 
 numberOfRowsInSection:(NSInteger)section { 
    return [list count]; 
} 

- (UITableViewCell *)tableView:(UITableView *)tableView 
         cellForRowAtIndexPath:(NSIndexPath *)indexPath { 
	
    static NSString * DisclosureButtonCellIdentifier = 
	@"DisclosureButtonCellIdentifier"; 
	
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier: 
                             DisclosureButtonCellIdentifier]; 
    if (cell == nil) { 
        cell = [[[UITableViewCell alloc] 
				 initWithStyle:UITableViewCellStyleDefault 
				 reuseIdentifier:DisclosureButtonCellIdentifier] autorelease]; 
    } 
    NSUInteger row = [indexPath row]; 
    NSString *rowString = [list objectAtIndex:row]; 
    cell.textLabel.text = rowString; 
    cell.accessoryType = UITableViewCellAccessoryDetailDisclosureButton; 
    [rowString release]; 
    return cell; 
} 

#pragma mark - 
#pragma mark Metody delegata tabeli 
- (void)tableView:(UITableView *)tableView 
didSelectRowAtIndexPath:(NSIndexPath *)indexPath { 
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle: 
						  @"Hej, widziałeś przycisk typu disclosure?" 
													message:@"Jeżeli próbujesz przejść dalej, po prostu naciśnij ten przycisk" 
												   delegate:nil
										  cancelButtonTitle:@"To się więcej nie powtórzy" 
										  otherButtonTitles:nil]; 
    [alert show]; 
    [alert release]; 
} 
- (void)tableView:(UITableView *)tableView 

accessoryButtonTappedForRowWithIndexPath:(NSIndexPath *)indexPath { 
    if (childController == nil) { 
        childController = [[DisclosureDetailController alloc] 
                           initWithNibName:@"DisclosureDetail" bundle:nil]; 
    } 
    childController.title = @"Naciśnięto przycisk typu disclosure"; 
    NSUInteger row = [indexPath row]; 
    NSString *selectedMovie = [list objectAtIndex:row]; 
    NSString *detailMessage = [[NSString alloc] 
							   initWithFormat:@"Naciśnięto przycisk dla filmu %@.", 
							   selectedMovie]; 
    childController.message = detailMessage; 
    childController.title = selectedMovie; 
    [detailMessage release]; 
    [self.navigationController pushViewController:childController 
                                         animated:YES]; 
}

@end
